//=================================================================
// A new Pedestrian Generator. It selects the models and skins for
// whatever it spawns at random, so we shouldn't get too many 
// identical pawns.
//
// Get ready for some bizarre looking people...
//
// Notes: (Model and relevant MultiSkins areas)
// _____________________________________________
// |LodMesh'DeusExCharacters.GM_DressShirt'
// |LodMesh'DeusExCharacters.GM_DressShirt_F'
// |____________________
// |0 = Face
// |1 = Pinkmask.
// |2 = Pinkmask.
// |3 = Pants
// |4 = Pinkmask.
// |5 = Torso
// |6 = Frames
// |7 = Lenses
// |____________________
// _____________________________________________
// |LodMesh'DeusExCharacters.GFM_TShirtPants'
// |____________________
// |0 = Face
// |1 = Pinkmask.
// |2 = Ponytail (or pinkmask)
// |3 = Frames
// |4 = Lenses
// |5 = Face
// |6 = Pants
// |7 = Torso
// |____________________
// _____________________________________________
// |LodMesh'DeusExCharacters.GM_Suit'
// |____________________
// |0 = Face
// |1 = Pants
// |2 = Face?
// |3 = Torso
// |4 = Lower Torso (same as 3)
// |5 = Frames
// |6 = Lenses
// |7 = Pinkmask
// |____________________
// _____________________________________________
// |LodMesh'DeusExCharacters.GFM_SuitSkirt'
// |____________________
// |0 = Face
// |1 = Pants
// |2 = Face?
// |3 = Legs
// |4 = Torso
// |5 = Skirt
// |6 = Frames
// |7 = Lenses
// |____________________
//
//
// Notes / skins used
//
//
// MALE HEADS:
//
//Texture'DeusExCharacters.Skins.TriadLumPathTex0'
//Texture'DeusExCharacters.Skins.ThugMaleTex0'
//Texture'DeusExCharacters.Skins.StantonDowdTex0'
//Texture'DeusExCharacters.Skins.SmugglerTex0'
//Texture'DeusExCharacters.Skins.SecretServiceTex0'
//Texture'DeusExCharacters.Skins.PhilipMeadTex0'
//Texture'DeusExCharacters.Skins.BartenderTex0'
//Texture'DeusExCharacters.Skins.AlexJacobsonTex0'
//Texture'DeusExCharacters.Skins.PaulDentonTex0'
//Texture'DeusExCharacters.Skins.NathanMadisonTex0'
//Texture'DeusExCharacters.Skins.MichaelHamnerTex0'
//Texture'DeusExCharacters.Skins.Male1Tex0'
//Texture'DeusExCharacters.Skins.LowerClassMale2Tex0'
//Texture'DeusExCharacters.Skins.JuanLebedevTex0'
//Texture'DeusExCharacters.Skins.JosephManderleyTex0'
//Texture'DeusExCharacters.Skins.JoeGreeneTex0'
//Texture'DeusExCharacters.Skins.JockTex0'
//Texture'DeusExCharacters.Skins.HowardStrongTex0'
//Texture'DeusExCharacters.Skins.GarySavageTex0'
//Texture'DeusExCharacters.Skins.BoatPersonTex0'
//
// FEMALE HEADS:
//
//Texture'DeusExCharacters.Skins.Businesswoman1Tex0'
//Texture'DeusExCharacters.Skins.Female1Tex0'
//Texture'DeusExCharacters.Skins.Female2Tex0'
//Texture'DeusExCharacters.Skins.Female4Tex0'
//Texture'DeusExCharacters.Skins.Hooker1Tex0'
//Texture'DeusExCharacters.Skins.Hooker2Tex0'
//Texture'DeusExCharacters.Skins.JordanSheaTex0'
//Texture'DeusExCharacters.Skins.LowerClassFemaleTex0'
//Texture'DeusExCharacters.Skins.MaidTex0'
//Texture'DeusExCharacters.Skins.MargaretWilliamsTex0'
//Texture'DeusExCharacters.Skins.NicoletteDuClareTex0'
//Texture'DeusExCharacters.Skins.NurseTex0'
//Texture'DeusExCharacters.Skins.RachelMeadTex0'
//Texture'DeusExCharacters.Skins.SandraRentonTex0'
//Texture'DeusExCharacters.Skins.SarahMeadTex0'
//Texture'DeusExCharacters.Skins.SecretaryTex0'
//
// MALE SHIRT MESH TOPS:
//
//Texture'DeusExCharacters.Skins.AlexJacobsonTex1'
//Texture'DeusExCharacters.Skins.ChildMaleTex1'
//Texture'DeusExCharacters.Skins.ChildMale2Tex1'
//Texture'DeusExCharacters.Skins.HowardStrongTex1'
//Texture'DeusExCharacters.Skins.Male1Tex1'
//Texture'DeusExCharacters.Skins.Male2Tex1'
//Texture'DeusExCharacters.Skins.Male3Tex1'
//Texture'DeusExCharacters.Skins.TriadLumPathTex1'
//Texture'DeusExCharacters.Skins.MechanicTex1'
//Texture'DeusExCharacters.Skins.ThugMale2Tex1'
//Texture'DeusExCharacters.Skins.Male1Tex1'
//Texture'DeusExCharacters.Skins.HowardStrongTex1'
//Texture'DeusExCharacters.Skins.ThugMale2Tex1'
//Texture'DeusExCharacters.Skins.SoldierTex1'
//Texture'DeusExCharacters.Skins.MorganEverettTex1'
//
// FEMALE TOPS;
//
//Texture'DeusExCharacters.Skins.LowerClassFemaleTex1'
//Texture'DeusExCharacters.Skins.Female1Tex1'
//Texture'DeusExCharacters.Skins.NicoletteDuClareTex1'
//Texture'DeusExCharacters.Skins.SarahMeadTex1'
//Texture'DeusExCharacters.Skins.TriadLumPathTex1'
//
// MALE PANTS:
//
//Texture'DeusExCharacters.Skins.AlexJacobsonTex2'
//Texture'DeusExCharacters.Skins.BobPageTex2'
//Texture'DeusExCharacters.Skins.Businessman1Tex2'
//Texture'DeusExCharacters.Skins.ChadTex2'
//Texture'DeusExCharacters.Skins.CopTex2'
//Texture'DeusExCharacters.Skins.HowardStrongTex2'
//Texture'DeusExCharacters.Skins.JCDentonTex3'
//Texture'DeusExCharacters.Skins.JockTex3'
//Texture'DeusExCharacters.Skins.JoJoFineTex2'
//Texture'DeusExCharacters.Skins.JuanLebedevTex3'
//Texture'DeusExCharacters.Skins.JunkieMaleTex2'
//Texture'DeusExCharacters.Skins.Male2Tex2'
//Texture'DeusExCharacters.Skins.Male4Tex2'
//Texture'DeusExCharacters.Skins.MechanicTex2'
//Texture'DeusExCharacters.Skins.MichaelHamnerTex2'
//Texture'DeusExCharacters.Skins.MJ12TroopTex1'
//Texture'DeusExCharacters.Skins.NathanMadisonTex2'
//Texture'DeusExCharacters.Skins.PantsTex1'
//Texture'DeusExCharacters.Skins.PantsTex10'
//Texture'DeusExCharacters.Skins.PantsTex2'
//Texture'DeusExCharacters.Skins.PantsTex3'
//Texture'DeusExCharacters.Skins.PantsTex4'
//Texture'DeusExCharacters.Skins.PantsTex5'
//Texture'DeusExCharacters.Skins.SoldierTex2'
//Texture'DeusExCharacters.Skins.PantsTex8'
//Texture'DeusExCharacters.Skins.PantsTex7'
//Texture'DeusExCharacters.Skins.PantsTex6' 27
//
// MALE SUITS:
//
//Texture'DeusExCharacters.Skins.PhilipMeadTex1'
//Texture'DeusExCharacters.Skins.PantsTex5'
//
//Texture'DeusExCharacters.Skins.BobPageTex1'
//Texture'DeusExCharacters.Skins.BobPageTex2'
//
//Texture'DeusExCharacters.Skins.Businessman1Tex1'
//Texture'DeusExCharacters.Skins.Businessman1Tex2'
//
//Texture'DeusExCharacters.Skins.Businessman2Tex1'
//Texture'DeusExCharacters.Skins.Businessman2Tex2'
//
//Texture'DeusExCharacters.Skins.Businessman3Tex1'
//Texture'DeusExCharacters.Skins.Businessman3Tex2'
//
//Texture'DeusExCharacters.Skins.JoeGreeneTex1'
//Texture'DeusExCharacters.Skins.BobPageTex2'
//
//Texture'DeusExCharacters.Skins.MIBTex1'
//Texture'DeusExCharacters.Skins.GordonQuickTex3'
//
//Texture'DeusExCharacters.Skins.MichaelHamnerTex1'
//Texture'DeusExCharacters.Skins.MichaelHamnerTex2'
//
//Texture'DeusExCharacters.Skins.SecretServiceTex1'
//Texture'DeusExCharacters.Skins.SecretServiceTex2'
//
// FEMALE SUITS:
//
//Texture'DeusExCharacters.Skins.WIBTex1'
//
//Texture'DeusExCharacters.Skins.SecretaryTex2'
//
//Texture'DeusExCharacters.Skins.RachelMeadTex1'
//
//Texture'DeusExCharacters.Skins.MargaretWilliamsTex1'
//
//Texture'DeusExCharacters.Skins.Businesswoman1Tex1'
//
//Texture'DeusExCharacters.Skins.Female2Tex2'
//
//Texture'DeusExCharacters.Skins.Female3Tex1'
//
//Texture'DeusExCharacters.Skins.MaggieChowTex1'
//
// FRAMES:
//
//Texture'DeusExCharacters.Skins.FramesTex1'
//Texture'DeusExCharacters.Skins.FramesTex2'
//Texture'DeusExCharacters.Skins.FramesTex3'
//Texture'DeusExCharacters.Skins.FramesTex4'
//Texture'DeusExCharacters.Skins.FramesTex5'
//
// LENSES:
//
//Texture'DeusExCharacters.Skins.LensesTex1'
//Texture'DeusExCharacters.Skins.LensesTex2'
//Texture'DeusExCharacters.Skins.LensesTex3'
//Texture'DeusExCharacters.Skins.LensesTex4'
//Texture'DeusExCharacters.Skins.LensesTex5'
//Texture'DeusExCharacters.Skins.LensesTex6'
//=================================================================
Class CozPedestrianGenerator extends Trigger;

var() Name PedestrianOrders;
var() bool bRandomDir;

function BeginPlay()
{
	GenerateSomeone();
}

function Timer()
{
	GenerateSomeone();
}

function GenerateSomeone()
{
	local CozPedestrian CP;
	local int r;
	local rotator rot;

	rot = Rotation;

	if(bRandomDir == true)
	{
		r=Rand(60000);
		rot.Yaw += r;
	}

	CP = Spawn(Class'CozPedestrian',,,Location, rot);
	CP.CPG = Self;
	CP.Orders = PedestrianOrders;

	r=Rand(4); //Select a model

	if((r == 0) || (r == 4)) //I don't think 4 can actually happen, but just in case...
	{
		r=Rand(4); // Should I be _F model? (1/4 chance)

		if(r == 2)
		{
			CP.Mesh = LodMesh'DeusExCharacters.GM_DressShirt_F';
		}
		else
		{
			CP.Mesh = LodMesh'DeusExCharacters.GM_DressShirt';
		}

		if(PedestrianOrders == 'Dancing') //This model has no dancing animation.
		{
			r=Rand(2);

			if(r == 0)
			{
				CP.Orders = 'Wandering';
			}
			else
			{
				CP.Orders = 'Standing';
			}
		}

		CP.MultiSkins[1] = Texture'DeusExItems.Skins.PinkMaskTex';
		CP.MultiSkins[2] = Texture'DeusExItems.Skins.PinkMaskTex';
		CP.MultiSkins[6] = Texture'DeusExItems.Skins.GrayMaskTex';
		CP.MultiSkins[7] = Texture'DeusExItems.Skins.BlackMaskTex';

		r=Rand(24); //Choose a head.

		if((r == 0) || (r == 24))
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex1';
		}
		else if(r == 1)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex2';
		}
		else if(r == 2)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex3';
		}
		else if(r == 3)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex4';
		}
		else if(r == 4)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.TriadLumPathTex0';
		}
		else if(r == 5)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.ThugMaleTex0';
		}
		else if(r == 6)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.StantonDowdTex0';
		}
		else if(r == 7)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SmugglerTex0';
		}
		else if(r == 8)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SecretServiceTex0';
		}
		else if(r == 9)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.PhilipMeadTex0';
		}
		else if(r == 10)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.BartenderTex0';
		}
		else if(r == 11)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.AlexJacobsonTex0';
		}
		else if(r == 12)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.PaulDentonTex0';
		}
		else if(r == 13)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.NathanMadisonTex0';
		}
		else if(r == 14)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.MichaelHamnerTex0';
		}
		else if(r == 15)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Male1Tex0';
		}
		else if(r == 16)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.LowerClassMale2Tex0';
		}
		else if(r == 17)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.JuanLebedevTex0';
		}
		else if(r == 18)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.JosephManderleyTex0';
		}
		else if(r == 19)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.JoeGreeneTex0';
		}
		else if(r == 20)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.JockTex0';
		}
		else if(r == 21)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.HowardStrongTex0';
		}
		else if(r == 22)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.GarySavageTex0';
		}
		else if(r == 23)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.BoatPersonTex0';
		}

		r=Rand(15); //A shirt...

		if((r == 0) || (r == 15))
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.AlexJacobsonTex1';
		}
		else if(r == 1)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.ChildMaleTex1';
		}
		else if(r == 2)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.ChildMale2Tex1';
		}
		else if(r == 3)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.HowardStrongTex1';
		}
		else if(r == 4)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.Male1Tex1';
		}
		else if(r == 5)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.Male2Tex1';
		}
		else if(r == 6)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.Male3Tex1';
		}
		else if(r == 7)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.TriadLumPathTex1';
		}
		else if(r == 8)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.MechanicTex1';
		}
		else if(r == 9)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.ThugMale2Tex1';
		}
		else if(r == 10)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.Male1Tex1';
		}
		else if(r == 11)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.HowardStrongTex1';
		}
		else if(r == 12)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.ThugMale2Tex1';
		}
		else if(r == 13)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.SoldierTex1';
		}
		else if(r == 14)
		{
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.MorganEverettTex1';
		}
		
		r=Rand(27); //And now for some pants.

		if((r == 0) || (r == 27))
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.AlexJacobsonTex2';
		}
		else if(r == 1)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.BobPageTex2';
		}
		else if(r == 2)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.Businessman1Tex2';
		}
		else if(r == 3)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.ChadTex2';
		}
		else if(r == 4)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.CopTex2';
		}
		else if(r == 5)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.HowardStrongTex2';
		}
		else if(r == 6)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.JCDentonTex3';
		}
		else if(r == 7)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.JockTex3';
		}
		else if(r == 8)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.JoJoFineTex2';
		}
		else if(r == 9)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.JuanLebedevTex3';
		}
		else if(r == 10)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.JunkieMaleTex2';
		}
		else if(r == 11)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.Male2Tex2';
		}
		else if(r == 12)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.Male4Tex2';
		}
		else if(r == 13)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.MechanicTex2';
		}
		else if(r == 14)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.MichaelHamnerTex2';
		}
		else if(r == 15)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.Businessman1Tex2';
		}
		else if(r == 16)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.NathanMadisonTex2';
		}
		else if(r == 17)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.PantsTex1';
		}
		else if(r == 18)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.PantsTex10';
		}
		else if(r == 19)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.PantsTex2';
		}
		else if(r == 20)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.PantsTex3';
		}
		else if(r == 21)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.PantsTex4';
		}
		else if(r == 22)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.PantsTex5';
		}
		else if(r == 23)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.SoldierTex2';
		}
		else if(r == 24)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.PantsTex8';
		}
		else if(r == 25)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.PantsTex7';
		}
		else if(r == 26)
		{
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.PantsTex6';
		}

		r=Rand(3); // Should I wear glasses? (1/3 chance)

		if(r == 2)
		{
			r=Rand(5); //What type of frame?

			if((r == 0) || (r == 5))
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.FramesTex1';
			}
			else if(r == 1)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.FramesTex2';
			}
			else if(r == 2)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.FramesTex3';
			}
			else if(r == 3)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.FramesTex4';
			}
			else if(r == 4)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.FramesTex5';
			}

			r=Rand(6); //And the lenses?

			if((r == 0) || (r == 5))
			{
				CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LensesTex1';
			}
			else if(r == 1)
			{
				CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LensesTex2';
			}
			else if(r == 2)
			{
				CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LensesTex3';
			}
			else if(r == 3)
			{
				CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LensesTex4';
			}
			else if(r == 4)
			{
				CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LensesTex5';
			}
			else if(r == 5)
			{
				CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LensesTex6';
			}
		}

		return;
	}
	else if(r == 1) //Normal female
	{
		CP.Mesh = LodMesh'DeusExCharacters.GFM_TShirtPants';
		CP.bIsFemale = true;

		CP.MultiSkins[1] = Texture'DeusExItems.Skins.PinkMaskTex';
		CP.MultiSkins[3] = Texture'DeusExItems.Skins.GrayMaskTex';
		CP.MultiSkins[4] = Texture'DeusExItems.Skins.BlackMaskTex';

		if(PedestrianOrders == 'Dancing')
		{
			r=Rand(2);

			if(r == 0)
			{
				CP.Orders = 'Wandering';
			}
			else
			{
				CP.Orders = 'Standing';
			}
		}

		r=Rand(16); //Choose a female head.

		if((r == 0) || (r == 16))
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Businesswoman1Tex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.Businesswoman1Tex0';
		}
		else if(r == 1)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Female1Tex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.Female1Tex0';
		}
		else if(r == 2)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Female2Tex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.Female2Tex0';
		}
		else if(r == 3)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Female4Tex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.Female4Tex0';
		}
		else if(r == 4)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Hooker1Tex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.Hooker1Tex0';
		}
		else if(r == 5)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Hooker2Tex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.Hooker2Tex0';
		}
		else if(r == 6)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.JordanSheaTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.JordanSheaTex0';
		}
		else if(r == 7)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.LowerClassFemaleTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.LowerClassFemaleTex0';
		}
		else if(r == 8)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.MaidTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.MaidTex0';
		}
		else if(r == 9)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.MargaretWilliamsTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.MargaretWilliamsTex0';
		}
		else if(r == 10)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.NicoletteDuClareTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.NicoletteDuClareTex0';
		}
		else if(r == 11)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.NurseTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.NurseTex0';
		}
		else if(r == 12)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.RachelMeadTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.RachelMeadTex0';
		}
		else if(r == 13)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SandraRentonTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.SandraRentonTex0';
		}
		else if(r == 14)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SarahMeadTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.SarahMeadTex0';
		}
		else if(r == 15)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SecretaryTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.SecretaryTex0';
		}

		r=Rand(4); //Choose a female torso.

		if((r == 0) || (r == 4))
		{
			CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LowerClassFemaleTex1';
		}
		else if(r == 1)
		{
			CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.Female1Tex1';
		}
		else if(r == 2)
		{
			CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.NicoletteDuClareTex1';
		}
		else if(r == 3)
		{
			CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.SarahMeadTex1';
		}

		r=Rand(27); //And now for some pants.

		if((r == 0) || (r == 27))
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.AlexJacobsonTex2';
		}
		else if(r == 1)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.BobPageTex2';
		}
		else if(r == 2)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.Businessman1Tex2';
		}
		else if(r == 3)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.ChadTex2';
		}
		else if(r == 4)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.CopTex2';
		}
		else if(r == 5)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.HowardStrongTex2';
		}
		else if(r == 6)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.JCDentonTex3';
		}
		else if(r == 7)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.JockTex3';
		}
		else if(r == 8)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.JoJoFineTex2';
		}
		else if(r == 9)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.JuanLebedevTex3';
		}
		else if(r == 10)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.JunkieMaleTex2';
		}
		else if(r == 11)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.Male2Tex2';
		}
		else if(r == 12)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.Male4Tex2';
		}
		else if(r == 13)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.MechanicTex2';
		}
		else if(r == 14)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.MichaelHamnerTex2';
		}
		else if(r == 15)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.Businessman1Tex2';
		}
		else if(r == 16)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.NathanMadisonTex2';
		}
		else if(r == 17)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.PantsTex1';
		}
		else if(r == 18)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.PantsTex10';
		}
		else if(r == 19)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.PantsTex2';
		}
		else if(r == 20)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.PantsTex3';
		}
		else if(r == 21)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.PantsTex4';
		}
		else if(r == 22)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.PantsTex5';
		}
		else if(r == 23)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.SoldierTex2';
		}
		else if(r == 24)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.PantsTex8';
		}
		else if(r == 25)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.PantsTex7';
		}
		else if(r == 26)
		{
			CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.PantsTex6';
		}

		r=Rand(3); // Should I wear glasses? (1/3 chance)

		if(r == 2)
		{
			r=Rand(5); //What type of frame?

			if((r == 0) || (r == 5))
			{
				CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.FramesTex1';
			}
			else if(r == 1)
			{
				CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.FramesTex2';
			}
			else if(r == 2)
			{
				CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.FramesTex3';
			}
			else if(r == 3)
			{
				CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.FramesTex4';
			}
			else if(r == 4)
			{
				CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.FramesTex5';
			}

			r=Rand(6); //And the lenses?

			if((r == 0) || (r == 5))
			{
				CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.LensesTex1';
			}
			else if(r == 1)
			{
				CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.LensesTex2';
			}
			else if(r == 2)
			{
				CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.LensesTex3';
			}
			else if(r == 3)
			{
				CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.LensesTex4';
			}
			else if(r == 4)
			{
				CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.LensesTex5';
			}
			else if(r == 5)
			{
				CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.LensesTex6';
			}
		}

		return;
	}
	else if(r == 2) //Male suit.
	{
		CP.Mesh = LodMesh'DeusExCharacters.GM_Suit';
		CP.MultiSkins[5] = Texture'DeusExItems.Skins.GrayMaskTex';
		CP.MultiSkins[6] = Texture'DeusExItems.Skins.BlackMaskTex';
		CP.MultiSkins[7] = Texture'DeusExItems.Skins.PinkMaskTex';

		r=Rand(24); //Choose a head.

		if((r == 0) || (r == 24))
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex1';
		}
		else if(r == 1)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex2';
		}
		else if(r == 2)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex3';
		}
		else if(r == 3)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SkinTex4';
		}
		else if(r == 4)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.TriadLumPathTex0';
		}
		else if(r == 5)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.ThugMaleTex0';
		}
		else if(r == 6)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.StantonDowdTex0';
		}
		else if(r == 7)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SmugglerTex0';
		}
		else if(r == 8)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SecretServiceTex0';
		}
		else if(r == 9)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.PhilipMeadTex0';
		}
		else if(r == 10)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.BartenderTex0';
		}
		else if(r == 11)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.AlexJacobsonTex0';
		}
		else if(r == 12)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.PaulDentonTex0';
		}
		else if(r == 13)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.NathanMadisonTex0';
		}
		else if(r == 14)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.MichaelHamnerTex0';
		}
		else if(r == 15)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Male1Tex0';
		}
		else if(r == 16)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.LowerClassMale2Tex0';
		}
		else if(r == 17)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.JuanLebedevTex0';
		}
		else if(r == 18)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.JosephManderleyTex0';
		}
		else if(r == 19)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.JoeGreeneTex0';
		}
		else if(r == 20)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.JockTex0';
		}
		else if(r == 21)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.HowardStrongTex0';
		}
		else if(r == 22)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.GarySavageTex0';
		}
		else if(r == 23)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.BoatPersonTex0';
		}

		r=Rand(9); //Which suit will I wear?

		if((r == 0) || (r == 9))
		{
			CP.MultiSkins[1] = Texture'DeusExCharacters.Skins.PantsTex5';
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.PhilipMeadTex1';
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.PhilipMeadTex1';
		}
		else if(r == 1)
		{
			CP.MultiSkins[1] = Texture'DeusExCharacters.Skins.BobPageTex2';
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.BobPageTex1';
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.BobPageTex1';
		}
		else if(r == 2)
		{
			CP.MultiSkins[1] = Texture'DeusExCharacters.Skins.Businessman1Tex2';
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.Businessman1Tex1';
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.Businessman1Tex1';
		}
		else if(r == 3)
		{
			CP.MultiSkins[1] = Texture'DeusExCharacters.Skins.Businessman2Tex2';
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.Businessman2Tex1';
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.Businessman2Tex1';
		}
		else if(r == 4)
		{
			CP.MultiSkins[1] = Texture'DeusExCharacters.Skins.Businessman3Tex2';
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.Businessman3Tex1';
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.Businessman3Tex1';
		}
		else if(r == 5)
		{
			CP.MultiSkins[1] = Texture'DeusExCharacters.Skins.BobPageTex2';
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.JoeGreeneTex1';
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.JoeGreeneTex1';
		}
		else if(r == 6)
		{
			CP.MultiSkins[1] = Texture'DeusExCharacters.Skins.GordonQuickTex3'; //oh yes.
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.MIBTex1';
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.MIBTex1';
		}
		else if(r == 7)
		{
			CP.MultiSkins[1] = Texture'DeusExCharacters.Skins.MichaelHamnerTex2';
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.MichaelHamnerTex1';
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.MichaelHamnerTex1';
		}
		else if(r == 8)
		{
			CP.MultiSkins[1] = Texture'DeusExCharacters.Skins.SecretServiceTex2';
			CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.SecretServiceTex1';
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.SecretServiceTex1';
		}

		r=Rand(3); // Should I wear glasses? (1/3 chance)

		if(r == 2)
		{
			r=Rand(5); //What type of frame?

			if((r == 0) || (r == 5))
			{
				CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.FramesTex1';
			}
			else if(r == 1)
			{
				CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.FramesTex2';
			}
			else if(r == 2)
			{
				CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.FramesTex3';
			}
			else if(r == 3)
			{
				CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.FramesTex4';
			}
			else if(r == 4)
			{
				CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.FramesTex5';
			}

			r=Rand(6); //And the lenses?

			if((r == 0) || (r == 5))
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.LensesTex1';
			}
			else if(r == 1)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.LensesTex2';
			}
			else if(r == 2)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.LensesTex3';
			}
			else if(r == 3)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.LensesTex4';
			}
			else if(r == 4)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.LensesTex5';
			}
			else if(r == 5)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.LensesTex6';
			}
		}

		return;
	}
	else if(r == 3)
	{
		CP.Mesh = LodMesh'DeusExCharacters.GFM_SuitSkirt';
		CP.bIsFemale = True;
		CP.MultiSkins[3] = Texture'DeusExCharacters.Skins.Female3Tex2';
		CP.MultiSkins[6] = Texture'DeusExItems.Skins.GrayMaskTex';
		CP.MultiSkins[7] = Texture'DeusExItems.Skins.BlackMaskTex';

		r=Rand(16); //Choose a female head.

		if((r == 0) || (r == 16))
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Businesswoman1Tex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.Businesswoman1Tex0';
		}
		else if(r == 1)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Female1Tex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.Female1Tex0';
		}
		else if(r == 2)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Female2Tex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.Female2Tex0';
		}
		else if(r == 3)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Female4Tex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.Female4Tex0';
		}
		else if(r == 4)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Hooker1Tex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.Hooker1Tex0';
		}
		else if(r == 5)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.Hooker2Tex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.Hooker2Tex0';
		}
		else if(r == 6)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.JordanSheaTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.JordanSheaTex0';
		}
		else if(r == 7)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.LowerClassFemaleTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.LowerClassFemaleTex0';
		}
		else if(r == 8)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.MaidTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.MaidTex0';
		}
		else if(r == 9)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.MargaretWilliamsTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.MargaretWilliamsTex0';
		}
		else if(r == 10)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.NicoletteDuClareTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.NicoletteDuClareTex0';
		}
		else if(r == 11)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.NurseTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.NurseTex0';
		}
		else if(r == 12)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.RachelMeadTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.RachelMeadTex0';
		}
		else if(r == 13)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SandraRentonTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.SandraRentonTex0';
		}
		else if(r == 14)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SarahMeadTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.SarahMeadTex0';
		}
		else if(r == 15)
		{
			CP.MultiSkins[0] = Texture'DeusExCharacters.Skins.SecretaryTex0';
			CP.MultiSkins[2] = Texture'DeusExCharacters.Skins.SecretaryTex0';
		}

		r=Rand(8); //Choose a female suit.

		if((r == 0) || (r == 8))
		{
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.WIBTex1';
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.WIBTex1';
		}
		else if(r == 1)
		{
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.SecretaryTex2';
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.SecretaryTex2';
		}
		else if(r == 2)
		{
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.RachelMeadTex1';
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.RachelMeadTex1';
		}
		else if(r == 3)
		{
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.MargaretWilliamsTex1';
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.MargaretWilliamsTex1';
		}
		else if(r == 4)
		{
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.Businesswoman1Tex1';
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.Businesswoman1Tex1';
		}
		else if(r == 5)
		{
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.Female2Tex2';
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.Female2Tex2';
		}
		else if(r == 6)
		{
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.Female3Tex1';
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.Female3Tex1';
		}
		else if(r == 7)
		{
			CP.MultiSkins[4] = Texture'DeusExCharacters.Skins.MaggieChowTex1';
			CP.MultiSkins[5] = Texture'DeusExCharacters.Skins.MaggieChowTex1';
		}

		r=Rand(3); // Should I wear glasses? (1/3 chance)

		if(r == 2)
		{
			r=Rand(5); //What type of frame?

			if((r == 0) || (r == 5))
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.FramesTex1';
			}
			else if(r == 1)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.FramesTex2';
			}
			else if(r == 2)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.FramesTex3';
			}
			else if(r == 3)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.FramesTex4';
			}
			else if(r == 4)
			{
				CP.MultiSkins[6] = Texture'DeusExCharacters.Skins.FramesTex5';
			}

			r=Rand(6); //And the lenses?

			if((r == 0) || (r == 5))
			{
				CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LensesTex1';
			}
			else if(r == 1)
			{
				CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LensesTex2';
			}
			else if(r == 2)
			{
				CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LensesTex3';
			}
			else if(r == 3)
			{
				CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LensesTex4';
			}
			else if(r == 4)
			{
				CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LensesTex5';
			}
			else if(r == 5)
			{
				CP.MultiSkins[7] = Texture'DeusExCharacters.Skins.LensesTex6';
			}
		}

		return;
	}
}

defaultproperties
{
     bRandomDir=False
     PedestrianOrders=Wandering
     Texture=Texture'Engine.S_Flag'
}
